/*
 * Decompiled with CFR 0.152.
 */
package com.t2pellet.strawgolem.crop;

import com.t2pellet.strawgolem.StrawgolemCommon;
import com.t2pellet.strawgolem.config.StrawgolemConfig;
import com.t2pellet.strawgolem.crop.CropRegistry;
import com.t2pellet.strawgolem.entity.EntityStrawGolem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;

class CropRegistryImpl
implements CropRegistry {
    private final Map<CropKey<?>, Object> entries = new HashMap();

    CropRegistryImpl() {
    }

    @Override
    public <T extends class_2680> void register(class_2248 id, CropRegistry.IHarvestChecker<T> harvestChecker, CropRegistry.IHarvestLogic<T> harvestLogic, CropRegistry.IReplantLogic<T> replantLogic) {
        StrawgolemCommon.LOG.debug("Registering crop block: {}", (Object)id);
        this.entries.put(new CropKey<class_2248>(id), new CropVal<T>(harvestChecker, harvestLogic, replantLogic));
    }

    @Override
    public <T extends class_2586> void register(class_2591<T> id, CropRegistry.IHarvestChecker<T> harvestChecker, CropRegistry.IHarvestLogic<T> harvestLogic, CropRegistry.IReplantLogic<T> replantLogic) {
        StrawgolemCommon.LOG.debug("Registering crop block: {}", id);
        this.entries.put(new CropKey<class_2591<T>>(id), new CropVal<T>(harvestChecker, harvestLogic, replantLogic));
    }

    @Override
    public <T extends class_2680> boolean isGrownCrop(T state) {
        return state != null && this.isGrownCrop(new CropKey<class_2248>(state.method_26204()), state) && StrawgolemConfig.Harvest.isHarvestAllowed(state.method_26204());
    }

    @Override
    public <T extends class_2586> boolean isGrownCrop(T block) {
        return block != null && this.isGrownCrop(new CropKey<class_2591>(block.method_11017()), block) && StrawgolemConfig.Harvest.isHarvestAllowed(block.method_11010().method_26204());
    }

    @Override
    public void handleReplant(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        CropKey<class_2248> blockKey = new CropKey<class_2248>(state.method_26204());
        if (this.contains(blockKey)) {
            this.handleReplant(blockKey, level, pos, state);
        } else {
            class_2586 entity = level.method_8321(pos);
            CropKey<class_2591> entityKey = new CropKey<class_2591>(entity.method_11017());
            if (this.contains(entityKey)) {
                this.handleReplant(entityKey, level, pos, entity);
            }
        }
    }

    @Override
    public List<class_1799> handleHarvest(class_3218 level, EntityStrawGolem golem, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        CropKey<class_2248> blockKey = new CropKey<class_2248>(state.method_26204());
        if (this.contains(blockKey)) {
            return this.handleHarvest(blockKey, level, golem, pos, state);
        }
        class_2586 entity = level.method_8321(pos);
        CropKey<class_2591> entityKey = new CropKey<class_2591>(entity.method_11017());
        if (this.contains(entityKey)) {
            return this.handleHarvest(entityKey, level, golem, pos, entity);
        }
        return List.of();
    }

    private <T> void handleReplant(CropKey<?> key, class_1937 level, class_2338 pos, T val) {
        if (this.contains(key)) {
            CropVal data = (CropVal)this.entries.get(key);
            data.replantLogic.doReplant(level, pos, val);
        }
    }

    private <T> boolean isGrownCrop(CropKey<?> key, T val) {
        if (this.contains(key)) {
            CropVal data = (CropVal)this.entries.get(key);
            return data.checker.isMature(val);
        }
        return false;
    }

    private <T> List<class_1799> handleHarvest(CropKey<?> key, class_3218 level, EntityStrawGolem golem, class_2338 pos, T val) {
        if (this.contains(key)) {
            CropVal data = (CropVal)this.entries.get(key);
            return data.harvestLogic.doHarvest(level, golem, pos, val);
        }
        return List.of();
    }

    private boolean contains(CropKey<?> id) {
        return id != null && id.get() != null && this.entries.containsKey(id);
    }

    private static class CropKey<T> {
        private final T obj;

        private CropKey(T obj) {
            this.obj = obj;
        }

        T get() {
            return this.obj;
        }

        public int hashCode() {
            return this.get().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof CropKey) {
                CropKey entry = (CropKey)obj;
                return this.get().equals(entry.get());
            }
            return this.get().equals(obj);
        }
    }

    private static class CropVal<T> {
        public final CropRegistry.IHarvestChecker<T> checker;
        public final CropRegistry.IHarvestLogic<T> harvestLogic;
        public final CropRegistry.IReplantLogic<T> replantLogic;

        public CropVal(CropRegistry.IHarvestChecker<T> checker, CropRegistry.IHarvestLogic<T> harvestLogic, CropRegistry.IReplantLogic<T> replantLogic) {
            this.checker = checker;
            this.harvestLogic = harvestLogic;
            this.replantLogic = replantLogic;
        }
    }
}

